#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Colourful rogo1965Mod01.fsh   by   rogo1965   
//https://www.shadertoy.com/view/ssBczW
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float size = 20.0;

//Noice function [0,1]
vec2 T = vec2(0.);
float No(float x){
return fract(9667.5*sin(7983.75*(x + T.x) + 297. + T.y));
}

vec4 Rancol(vec2 x){
return vec4(No(x.x + x.y), No(x.x*x.x+ x.y), No(x.x*x.x + x.y*x.y),1.);
}

//bubbles!!
vec4 grid(vec2 uv, float t){
vec4 C1,C2;
uv *= size;
vec2 id = vec2(int(uv.x),int(uv.y));
uv.y += (5.*No(id.x*id.x) + 1.)*t*.4	;
uv.y += No(id.x);
  id = vec2(int(uv.x), int(uv.y));
uv = fract(uv) - .5;

//if (id == vec2(1,10)){C1 = vec4(1.);}

float d = length(uv);
t *= 10.*No(id.x + id.y);
//uv.x += No(id.x);
//if (uv.x > .46 || uv.y > .46){C1 = vec4(1.);}

float r = .1*sin(t + sin(t)*.5)+.3;
float r1 = .07*sin(2.*t + sin(2.*t)*.5) +.1*No(id.x + id.y);
  if (d<r && d>r-.1){
  C2 = 1.9*Rancol(id + vec2(1.)) + vec4(.5);
  C2 *= smoothstep(r-.12,r,d);
  C2 *= 1. - smoothstep(r-.05, r+.12,d);
  }

  if (d<r1){
  C2 = .5*Rancol(id + vec2(1.)) + vec4(.5);
  }

  return C2 + C1;
}
#define C fragColor
#define U fragCoord
//void mainImage( out vec4 C, in vec2 U ){
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 C, in vec2 U )
{ 
vec2 uv = U / iResolution.xy;
uv.y *= iResolution.y/iResolution.x;
float t = iTime;
T = iMouse.xy;
fragColor = vec4(grid(uv, -t));
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

